/*
* Author: GerryL (Backshed)
* History:
*	Version 1.0 : 15 April 20. Initial release. 
* 
* ConCFuncSubGen.cpp : This file contains the 'main' function. Program execution begins and ends there.
*    Licence:
* This code is covered by the licence as detailed at https://unlicense.org/ , which is essentially its in the public domain, but "AS IS", WITHOUT WARRANTY OF ANY KIND
* 
*/

#include "pch.h"
#include <windows.h>
#include <comutil.h>
#include <iostream>
#include <string.h>
#include <conio.h>
#include <fstream> 
#include <tchar.h>
#include "CElfToCSub.h"



std::wstring m_swELFFile_Path;

void clear_screen(HANDLE console) {
    COORD tl = { 0,0 };
    CONSOLE_SCREEN_BUFFER_INFO s;
    // HANDLE console = GetStdHandle(STD_OUTPUT_HANDLE);
    GetConsoleScreenBufferInfo(console, &s);
    DWORD written, cells = s.dwSize.X * s.dwSize.Y;
    FillConsoleOutputCharacter(console, ' ', cells, tl, &written);
    FillConsoleOutputAttribute(console, s.wAttributes, cells, tl, &written);
    SetConsoleCursorPosition(console, tl);
}

std::wstring UT8ToWide(const std::string sin) {
    int nsize = MultiByteToWideChar(CP_UTF8, 0, &sin[0], (int)sin.size(), NULL, 0);// last param = 0 so requird size returned
    std::wstring wswide(nsize, 0);// string of correct size
    MultiByteToWideChar(CP_UTF8, 0, &sin[0], (int)sin.size(), &wswide[0], nsize);
    return wswide;
};

void ManageError(int nError)
{
    std::wcout << std::endl << std::endl << L"**********************************************************" << std::endl << std::endl;
    switch (nError) {
    case ERROR_ELF_OPEN:
        std::wcout << L"***  ERROR Could Not Open ELF File!  ***" << std::endl << std::endl;
        break;
    case ERROR_ELF_STRING_TABLE_NOT_FOUND:
        std::wcout << L"***  ERROR String Table vector not Populated!  ***" << std::endl << std::endl;
        break;
    case ERROR_ELF_BASIC_FILE_CREATE:
        std::wcout << L"***  ERROR Could not create the BASIC File!  ***" << std::endl << std::endl;
        break;
    case ERROR_ELF_C_FILE_OPEN:
        std::wcout << L"***  ERROR Could not open the C source File!  ***" << std::endl << std::endl;
        break;
    case ERROR_ELF_HDR_BYTES:
        std::wcout << L"***  ERROR ELF File Header size incorrect!  ***" << std::endl << std::endl;
        break;
    case ERROR_ELF_SECTION_HDR_SIZE:
        std::wcout << L"***  ERROR ELF File Header size incorrect!  ***" << std::endl << std::endl;
        break;
    case ERROR_ELF_SECTION_HDR_READ:
        std::wcout << L"***  ERROR ELF File Header read!  ***" << std::endl << std::endl;
        break;
    case ERROR_ELF_SYMB_TABLE_READ:
        std::wcout << L"***  ERROR ELF File Symbol Table read!  ***" << std::endl << std::endl;
        break;
    case ERROR_ELF_NOT_ELF_FILE:
        std::wcout << L"***  ERROR NOT a correct ELF File!  ***" << std::endl << std::endl;
        break;
    case ERROR_TIME_STRUCT_FILL:
        std::wcout << L"***  ERROR filling time structure!  ***" << std::endl << std::endl;
        break;
    case ERROR_TIME_ASC_CONVERT:
        std::wcout << L"***  ERROR converting time to string!  ***" << std::endl << std::endl;
        break;
    case ERROR_JOIN_CONST_DATA:
        std::wcout << L"***  ERROR JOIN CANNOT have static const data!  ***" << std::endl << std::endl;
        break;
    default:
            std::wcout << L"***  UNKNOWN ERROR!  ***" << std::endl << std::endl;
    } // end switch
    std::wcout << std::endl << std::endl << L"**********************************************************" << std::endl;
    std::wcout << std::endl << L"PRESS ANY KEY TO CONTINUE....." << std::endl;
    int ch = _getch();
}

int main(int argc, char* argv[])
{
    //BasicFileOpen();
    //return 0;
   
    try {
        HANDLE hConsole = GetStdHandle(STD_OUTPUT_HANDLE);
        if (hConsole == INVALID_HANDLE_VALUE) {
            _tprintf(L"Get Handle failed (%d)\n", GetLastError());
            return 1;
        }
        if (!SetConsoleTextAttribute(hConsole, BACKGROUND_BLUE | FOREGROUND_INTENSITY | FOREGROUND_BLUE | FOREGROUND_RED | FOREGROUND_GREEN)) // white lettering on blue
        {
            _tprintf(L"SetConsoleTColour failed (%d)\n", GetLastError());
            return 1;
        }
        clear_screen(hConsole);
        // get dropped name
        std::wstring sw_Ext;
        if (argc > 1) {
            wchar_t wtemp[MAX_PATH];
            size_t size = strlen(argv[1]) + 1;
            size_t outSize;
            mbstowcs_s(&outSize, wtemp, size, argv[1], size - 1);//convert to wide string
            m_swELFFile_Path = wtemp;
        }
        else {
            std::wcout << L"Please drop an 'Executable and Linkable Format (ELF)' file onto the screen..." << std::endl;
            int ch = _getch(); // 
            if (ch == '\"') {  // path containing spaces. read til next '"' ...
                while ((ch = _getch()) != '\"') {
                    m_swELFFile_Path += ch;
                    if (ch == '.') break;
                }
            }
            else { // path not containing spaces. read as long as chars are coming rapidly.
                m_swELFFile_Path += ch;
                while (_kbhit()) {
                    ch = _getch();
                    m_swELFFile_Path += ch;
                    if (ch == '.') break;
                }
            }
            for (int i = 0; i < 3; i++) {
                m_swELFFile_Path += _getch();
            }
        } // else dropped on open console
        std::string sInput;
        std::string sMergeName;
        int nMergeJoin;
        int nFuncSubType;
        // Get Merge or Join Type
        while (_kbhit()) // clear any chars before entering data
            int ch = _getch();
        while (1) {
           
            std::wcout << L"Enter M for MERGE Or J for JOIN or E to EXIT PROGRAM (case insenstitive) " << std::endl;
            
            std::cin >> sInput;
            sInput = toupper(sInput[0]);
            if (sInput.find("E") != std::string::npos)
                return 0; // exit program
            if (sInput.find("M") == std::string::npos && sInput.find("J") == std::string::npos) { // neither M or J
                std::wcout << L"Incorrect Entry, please re-enter ...  (only M or J accepted)" << std::endl;
            }
            else {
                if (sInput.find("M") != std::string::npos) {
                    nMergeJoin = MERGE_TYPE;
                    // get Name of the CSub or CFunction
                    std::wcout << L"Enter MERGE Name" << std::endl;
                    std::cin >> sMergeName;
                }
                if (sInput.find("J") != std::string::npos) {
                    nMergeJoin = JOIN_TYPE;
                }
                break; // all good
            }
        }//while
        // see if we have a c source file in the same folder
        std::wstring wssourcefile(m_swELFFile_Path);
        std::string::size_type ndot = wssourcefile.find('.');
        if (ndot != std::wstring::npos) {
            wssourcefile.erase(ndot + 1);
            wssourcefile += L"c";
            std::ifstream cfcomp;
            cfcomp.open(wssourcefile, std::ifstream::in | std::ifstream::binary);
            if (!cfcomp.good()) {
                wssourcefile = L"";
            }
            else cfcomp.close();
        }
        std::unique_ptr<CElfToCSub> pElf(new CElfToCSub(m_swELFFile_Path, UT8ToWide(sMergeName), wssourcefile, nMergeJoin, CFUNC_TYPE));// will sort out func or type once loaded so use CFUNC_TYPE
        int nBoardType = pElf->Load_ELFFile();// either MMPLUS_TYPE or MERGE_TYPE
        if (nBoardType >= 0) { // no error
            if (nBoardType == CMM2_TYPE)
                std::wcout << L"*******    A CMM2 ELF File Detected    *******" << std::endl << std::endl;
            else if (nBoardType == MMPLUS_TYPE)
                std::wcout << L"*******    A MM+ ELF File Detected    *******" << std::endl << std::endl;
            if (nBoardType == CMM2_TYPE)
                nFuncSubType = CSUB_TYPE; // force
            else { //MMPlus
                while (1) {
                    std::wcout << L"ENTER F for CFunction or S for CSub (case insenstitive)" << std::endl;
                    std::cin >> sInput;
                    sInput = toupper(sInput[0]);
                    if (sInput.find("S") == std::string::npos && sInput.find("F") == std::string::npos) { // neither S or F
                        std::wcout << L"Incorrect Entry, please re-enter ...  (only S or F accepted)" << std::endl;
                    }
                    else {
                        if (sInput.find("S") != std::string::npos) {
                            nFuncSubType = CSUB_TYPE;
                        }
                        else if (sInput.find("F") != std::string::npos) {
                            nFuncSubType = CFUNC_TYPE;
                        }
                        break;
                    }
                } // while getting Function or Sub
            } 
            // is calling format required?
            std::wcout << L"Is CALLING FORMAT COMMENT Required? ENTER Y if REQUIRED ... or N for NO (case insenstitive)" << std::endl;
            std::cin >> sInput;
            sInput = toupper(sInput[0]);
            if (sInput.find("Y") == std::string::npos) { // Y not detected so NOT Required
                pElf->ClearCSourcePath(); // C source path empty so comment not generated
            }
            std::wcout << L"   WAIT PROCESSING ........." << std::endl << std::endl;
            pElf->SetFuncSubType(nFuncSubType);
            long nRet = pElf->CreateCFunctions();
            if (nRet < 0) {
                clear_screen(hConsole);
                ManageError(nRet);
                return 1;
            }
            clear_screen(hConsole);
            // uncomment this if you want to see the CSUB on the screen, can be a pain if big CSUB
            //std::wcout << pElf->m_wstrCode << std::endl << std::endl;// show on screen for immediate evaluation
            std::wcout << pElf->m_wsFunctionInfo << std::endl << std::endl;
            std::wcout << pElf->TextSize() << std::endl << std::endl;
            std::wcout << std::endl << L"PRESS ANY KEY TO EXIT" << std::endl;
            int ch = _getch();
            return 0;
        } // good file load
        else {
            clear_screen(hConsole);
            ManageError(nBoardType);
            return 1;
        }
    } // try
    catch (const std::exception& e) {// unmanaged errors
        std::cout << e.what() << std::endl;
        return 1;
    }
    
}


